using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class s_TimeManager : MonoBehaviour
{
	//IMPORTANT: found out that weird things will happen if the time manager is not before the rewindables in the build order!
	
	public const int sFrameRate = 60;	//The target framerate
	public static int sRewindSpeed = 1;	//How fast the rewind is going
	public static int sTimeStamp = 0;	//The all mighty time stamp. Lets things know when to do stuff
	public static bool sRewind = false;	//If you are rewinding
	
	int mStartRewindTime = 0;			//This will be whatever sTimeStamp is when you press the rewind button
	int mMaxRewindSpeed = 8;			//Should be a power of 2
	
	public delegate void mRewindMessage();
	
	mRewindMessage mRewindStartFuncs;
	mRewindMessage mRewindEndFuncs;
	mRewindMessage mRewindChangeFuncs;
	
	
	void LateUpdate()
	{
		//Speed/Slow rewind when you press up or down
		CheckInputSpeedChange();
		
		//Checks if you press the rewind button
		CheckInputRewind();
		
		//Increment(or decrement) the time
		UpdateTimeStamp();
	}
	
	
	void UpdateTimeStamp()
	{
		if (Time.timeScale != 0)
			sTimeStamp += 1*sRewindSpeed;
		
		//Will stop if you get back to the beginning
		if (sRewind && sTimeStamp < 0)
		{
			sTimeStamp = 0;
			Time.timeScale = 0;
		}
		
		//When you forward to the start of your rewind, go no further
		if (sRewind && sTimeStamp > mStartRewindTime)
		{
			sTimeStamp = mStartRewindTime;
			Time.timeScale = 0;
		}
	}
	
	void CheckInputRewind()
	{
		if (Input.GetButtonDown("Rewind"))
		{
			mStartRewindTime = sTimeStamp;
			
			Time.timeScale = 1;
			sRewindSpeed = -1;
			sRewind = true;
			//UpdateTimeStamp();
			TellRewindStart();
		}
		if (Input.GetButtonUp("Rewind"))
		{	
			Time.timeScale = 1;
			sRewindSpeed = 1;
			sRewind = false;
			//UpdateTimeStamp();
			TellRewindEnd();
		}
	}
	
	
	void CheckInputSpeedChange()
	{
		if (sRewind)
		{
			if(Input.GetButtonDown("RewindUp"))
			{	
				//Turn off freeze
				if (sRewindSpeed == 0)
				{
					Time.timeScale = 1;
					sRewindSpeed = 1;
				}
				//Stop
				else if (sRewindSpeed == -1)
				{
					sRewindSpeed = 0;
					Time.timeScale = 0;
				}
				//Faster
				else if (sRewindSpeed < mMaxRewindSpeed && sRewindSpeed > 0)
					sRewindSpeed *= 2;
				else if (sRewindSpeed > -mMaxRewindSpeed-1 && sRewindSpeed < 0)
					sRewindSpeed /= 2;
				
				TellChangeSpeed();
			}
			else if (Input.GetButtonDown("RewindDown"))
			{
				//Turn off freeze
				if (sRewindSpeed == 0)
				{
					Time.timeScale = 1;
					sRewindSpeed = -1;
				}
				//Stop
				else if (sRewindSpeed == 1)
				{
					sRewindSpeed = 0;
					Time.timeScale = 0;
				}
				//Slower
				else if (sRewindSpeed < mMaxRewindSpeed+1 && sRewindSpeed > 0)
					sRewindSpeed /= 2;
				else if (sRewindSpeed > -mMaxRewindSpeed && sRewindSpeed < 0)
					sRewindSpeed *= 2;
				
				TellChangeSpeed();
			}
		}
	}
	
	//////////////////
	// Delegate functions
	public void AddStartFunction(mRewindMessage aStartFunc)
	{
		mRewindStartFuncs += aStartFunc;
	}
	
	public void AddEndFunction(mRewindMessage aEndFunc)
	{
		mRewindEndFuncs += aEndFunc;
	}
	
	public void AddChangeFunction(mRewindMessage aChangeFunc)
	{
		mRewindChangeFuncs += aChangeFunc;
	}
	
	void TellRewindStart()
	{
		if (mRewindStartFuncs != null) mRewindStartFuncs();
	}
	
	void TellRewindEnd()
	{
		if (mRewindEndFuncs != null) mRewindEndFuncs();
	}
	
	void TellChangeSpeed()
	{
		if (mRewindChangeFuncs != null) mRewindChangeFuncs();
	}
	////////////////////
	
	////////////////////
	// Singleton stuff
	
	static s_TimeManager sInstance;
 
    void Awake()
	{	
		Application.targetFrameRate = sFrameRate;
		
        if (sInstance != null)
            return;
 
        sInstance = this;
    }
 
    public static s_TimeManager Get
    {
        get
        {
            if (sInstance == null)
                new s_AudioManager();
 
            return sInstance;
        }
    }
	
	void OnEnable() //For some reason Awake() wasn't getting called before other objects Start(), and this fixed it. WTF right?
	{ }
	////////////////////
	
}